/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb3;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.mongodb3.LevelCodec;
import org.apache.logging.log4j.mongodb3.MongoDbConnection;
import org.apache.logging.log4j.mongodb3.MongoDbDocumentObjectCodec;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

@Plugin(name="MongoDb3", category="Core", printObject=true)
public final class MongoDbProvider
implements NoSqlProvider<MongoDbConnection> {
    private static final int DEFAULT_COLLECTION_SIZE = 0x20000000;
    private static final int DEFAULT_PORT = 27017;
    private static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.ACKNOWLEDGED;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String collectionName;
    private final Integer collectionSize;
    private final String description;
    private final boolean isCapped;
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private MongoDbProvider(MongoClient mongoClient, MongoDatabase mongoDatabase, String collectionName, boolean isCapped, Integer collectionSize, String description) {
        this.mongoClient = mongoClient;
        this.mongoDatabase = mongoDatabase;
        this.collectionName = collectionName;
        this.isCapped = isCapped;
        this.collectionSize = collectionSize;
        this.description = "mongoDb{ " + description + " }";
    }

    public MongoDbConnection getConnection() {
        return new MongoDbConnection(this.mongoClient, this.mongoDatabase, this.collectionName, this.isCapped, this.collectionSize);
    }

    public String toString() {
        return this.description;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<MongoDbProvider> {
        private static final CodecRegistry CODEC_REGISTRIES = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{LevelCodec.INSTANCE}), CodecRegistries.fromCodecs((Codec[])new Codec[]{new MongoDbDocumentObjectCodec()})});
        @PluginBuilderAttribute
        @Required(message="No collection name provided")
        private String collectionName;
        @PluginBuilderAttribute
        private int collectionSize = 0x20000000;
        @PluginBuilderAttribute
        @Required(message="No database name provided")
        private String databaseName;
        @PluginBuilderAttribute
        private String factoryClassName;
        @PluginBuilderAttribute
        private String factoryMethodName;
        @PluginBuilderAttribute(value="capped")
        private boolean capped = false;
        @PluginBuilderAttribute(sensitive=true)
        private String password;
        @PluginBuilderAttribute
        @ValidPort
        private String port = "27017";
        @PluginBuilderAttribute
        @ValidHost
        private String server = "localhost";
        @PluginBuilderAttribute
        private String userName;
        @PluginBuilderAttribute
        private String writeConcernConstant;
        @PluginBuilderAttribute
        private String writeConcernConstantClassName;

        private static WriteConcern toWriteConcern(String writeConcernConstant, String writeConcernConstantClassName) {
            WriteConcern writeConcern;
            if (Strings.isNotEmpty((CharSequence)writeConcernConstant)) {
                if (Strings.isNotEmpty((CharSequence)writeConcernConstantClassName)) {
                    try {
                        Class writeConcernConstantClass = LoaderUtil.loadClass((String)writeConcernConstantClassName);
                        Field field = writeConcernConstantClass.getField(writeConcernConstant);
                        writeConcern = (WriteConcern)field.get(null);
                    }
                    catch (Exception e) {
                        LOGGER.error("Write concern constant [{}.{}] not found, using default.", (Object)writeConcernConstantClassName, (Object)writeConcernConstant);
                        writeConcern = DEFAULT_WRITE_CONCERN;
                    }
                } else {
                    writeConcern = WriteConcern.valueOf((String)writeConcernConstant);
                    if (writeConcern == null) {
                        LOGGER.warn("Write concern constant [{}] not found, using default.", (Object)writeConcernConstant);
                        writeConcern = DEFAULT_WRITE_CONCERN;
                    }
                }
            } else {
                writeConcern = DEFAULT_WRITE_CONCERN;
            }
            return writeConcern;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public MongoDbProvider build() {
            String description;
            MongoDatabase database;
            MongoClient mongoClient = null;
            if (Strings.isNotEmpty((CharSequence)this.factoryClassName) && Strings.isNotEmpty((CharSequence)this.factoryMethodName)) {
                try {
                    Class factoryClass = LoaderUtil.loadClass((String)this.factoryClassName);
                    Method method = factoryClass.getMethod(this.factoryMethodName, new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    if (object instanceof MongoDatabase) {
                        database = (MongoDatabase)object;
                    } else if (object instanceof MongoClient) {
                        if (!Strings.isNotEmpty((CharSequence)this.databaseName)) {
                            LOGGER.error("The factory method [{}.{}()] returned a MongoClient so the database name is required.", (Object)this.factoryClassName, (Object)this.factoryMethodName);
                            return null;
                        }
                        database = ((MongoClient)object).getDatabase(this.databaseName);
                    } else {
                        if (object == null) {
                            LOGGER.error("The factory method [{}.{}()] returned null.", (Object)this.factoryClassName, (Object)this.factoryMethodName);
                            return null;
                        }
                        LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)object.getClass().getName());
                        return null;
                    }
                    String databaseName = database.getName();
                    description = "database=" + databaseName;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("The factory class [{}] could not be loaded.", (Object)this.factoryClassName, (Object)e);
                    return null;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)e);
                    return null;
                }
                catch (Exception e) {
                    LOGGER.error("The factory method [{}.{}()] could not be invoked.", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)e);
                    return null;
                }
            }
            if (!Strings.isNotEmpty((CharSequence)this.databaseName)) {
                LOGGER.error("No factory method was provided so the database name is required.");
                this.close(mongoClient);
                return null;
            }
            MongoCredential mongoCredential = null;
            description = "database=" + this.databaseName;
            if (Strings.isNotEmpty((CharSequence)this.userName) && Strings.isNotEmpty((CharSequence)this.password)) {
                description = description + ", username=" + this.userName;
                mongoCredential = MongoCredential.createMongoCRCredential((String)this.userName, (String)this.databaseName, (char[])this.password.toCharArray());
            }
            try {
                int portInt = (Integer)TypeConverters.convert((String)this.port, Integer.TYPE, (Object)27017);
                description = description + ", server=" + this.server + ", port=" + portInt;
                WriteConcern writeConcern = Builder.toWriteConcern(this.writeConcernConstant, this.writeConcernConstantClassName);
                MongoClientOptions options = MongoClientOptions.builder().codecRegistry(CODEC_REGISTRIES).writeConcern(writeConcern).build();
                ServerAddress serverAddress = new ServerAddress(this.server, portInt);
                mongoClient = mongoCredential == null ? new MongoClient(serverAddress, options) : new MongoClient(serverAddress, mongoCredential, options);
                database = mongoClient.getDatabase(this.databaseName);
            }
            catch (Exception e) {
                LOGGER.error("Failed to obtain a database instance from the MongoClient at server [{}] and port [{}].", (Object)this.server, (Object)this.port);
                this.close(mongoClient);
                return null;
            }
            try {
                database.listCollectionNames().first();
                return new MongoDbProvider(mongoClient, database, this.collectionName, this.capped, this.collectionSize, description);
            }
            catch (Exception e) {
                LOGGER.error("The database is not up, or you are not authenticated, try supplying a username and password to the MongoDB provider.", (Throwable)e);
                this.close(mongoClient);
                return null;
            }
        }

        private void close(MongoClient mongoClient) {
            if (mongoClient != null) {
                mongoClient.close();
            }
        }

        public B setCapped(boolean isCapped) {
            this.capped = isCapped;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionName(String collectionName) {
            this.collectionName = collectionName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(int collectionSize) {
            this.collectionSize = collectionSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryClassName(String factoryClassName) {
            this.factoryClassName = factoryClassName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryMethodName(String factoryMethodName) {
            this.factoryMethodName = factoryMethodName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPassword(String password) {
            this.password = password;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPort(String port) {
            this.port = port;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setServer(String server) {
            this.server = server;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUserName(String userName) {
            this.userName = userName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setWriteConcernConstant(String writeConcernConstant) {
            this.writeConcernConstant = writeConcernConstant;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setWriteConcernConstantClassName(String writeConcernConstantClassName) {
            this.writeConcernConstantClassName = writeConcernConstantClassName;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

