/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        BufferedBlockCipher bufferedBlockCipher = bl2 ? new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8)) : new BufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            bufferedBlockCipher.init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            bufferedBlockCipher.init(bl, (CipherParameters)keyParameter);
        }
        return bufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            @Override
            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
        bufferedBlockCipher.init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray2));
        return bufferedBlockCipher;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    private static long getChunkLength(int n) {
        return 1L << n + 6;
    }

    static PGPDataDecryptor createDataDecryptor(final int n, final byte[] byArray, final int n2, final int n3, byte[] byArray2) throws PGPException {
        final KeyParameter keyParameter = new KeyParameter(byArray2);
        final AEADBlockCipher aEADBlockCipher = BcUtil.createAEADCipher(n3, n);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                try {
                    return new PGPAeadInputStream(inputStream, aEADBlockCipher, keyParameter, byArray, n3, n, n2);
                }
                catch (IOException iOException) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + iOException.getMessage()), (Throwable)iOException);
                }
            }

            @Override
            public int getBlockSize() {
                return aEADBlockCipher.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static AEADBlockCipher createAEADCipher(int n, int n2) throws PGPException {
        if (n != 7 && n != 8 && n != 9) {
            throw new PGPException("AEAD only supported for AES based algorithms");
        }
        switch (n2) {
            case 1: {
                return new EAXBlockCipher((BlockCipher)new AESEngine());
            }
            case 2: {
                return new OCBBlockCipher((BlockCipher)new AESEngine(), (BlockCipher)new AESEngine());
            }
            case 3: {
                return new GCMBlockCipher((BlockCipher)new AESEngine());
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + n2);
    }

    static byte[] getNonce(byte[] byArray, long l) {
        byte[] byArray2 = Arrays.clone((byte[])byArray);
        BcUtil.xorChunkId(byArray2, l);
        return byArray2;
    }

    static void xorChunkId(byte[] byArray, long l) {
        int n = byArray.length - 8;
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] ^ (byte)(l >> 56));
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(l >> 48));
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] ^ (byte)(l >> 40));
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] ^ (byte)(l >> 32));
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] ^ (byte)(l >> 24));
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] ^ (byte)(l >> 16));
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] ^ (byte)(l >> 8));
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] ^ (byte)l);
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final byte[] data;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(OutputStream outputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, int n, int n2, int n3, byte[] byArray) {
            this.out = outputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcUtil.getChunkLength(n3);
            this.data = new byte[this.chunkLength];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)n;
            this.aaData[3] = (byte)n2;
            this.aaData[4] = (byte)n3;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (n2 < this.data.length - this.dataOff) {
                System.arraycopy(byArray, n, this.data, this.dataOff, n2);
                this.dataOff += n2;
            } else {
                int n3 = this.data.length - this.dataOff;
                System.arraycopy(byArray, n, this.data, this.dataOff, n3);
                this.dataOff += n3;
                this.writeBlock();
                n2 -= n3;
                n += n3;
                while (n2 >= this.data.length) {
                    System.arraycopy(byArray, n, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    n2 -= this.data.length;
                    n += this.data.length;
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.data, 0, n2);
                    this.dataOff = n2;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] byArray = new byte[13];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            BcUtil.xorChunkId(byArray, this.chunkIndex);
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                int n = this.c.processBytes(this.data, 0, this.dataOff, this.data, 0);
                this.out.write(this.data, 0, n);
                n = this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] byArray = new byte[13];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            BcUtil.xorChunkId(byArray, this.chunkIndex);
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, 16);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
            }
        }
    }

    private static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, int n, int n2, int n3) throws IOException {
            this.in = inputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcUtil.getChunkLength(n3);
            this.buf = new byte[this.chunkLength + 32];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)n;
            this.aaData[3] = (byte)n2;
            this.aaData[4] = (byte)n3;
            Streams.readFully((InputStream)inputStream, (byte[])this.buf, (int)0, (int)32);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int n3 = Math.min(n2, this.available());
            System.arraycopy(this.data, this.dataOff, byArray, n, n3);
            this.dataOff += n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = (int)Math.min(l, (long)this.available());
            this.dataOff += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            int n = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)32, (int)this.chunkLength);
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[13];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            BcUtil.xorChunkId(byArray, this.chunkIndex);
            byte[] byArray2 = new byte[n];
            try {
                this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                int n2 = this.c.processBytes(this.buf, 0, n + 16, byArray2, 0);
                this.c.doFinal(byArray2, n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)byArray2.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, n + 16, this.buf, 0, 16);
            if (n != this.chunkLength) {
                byArray = new byte[13];
                System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
                BcUtil.xorChunkId(byArray, this.chunkIndex);
                try {
                    this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcUtil.getNonce(this.iv, this.chunkIndex)));
                    this.c.processAADBytes(byArray, 0, byArray.length);
                    this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                    this.c.processBytes(this.buf, 0, 16, this.buf, 0);
                    this.c.doFinal(this.buf, 0);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)16, (int)16);
            }
            return byArray2;
        }
    }
}

