/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client.gridfs.helpers;

import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.gridfs.AsyncInputStream;
import com.mongodb.async.client.gridfs.AsyncOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import org.bson.assertions.Assertions;

public final class AsynchronousChannelHelper {
    public static AsyncInputStream channelToInputStream(final AsynchronousByteChannel asynchronousByteChannel) {
        Assertions.notNull((String)"asynchronousByteChannel", (Object)asynchronousByteChannel);
        return new AsyncInputStream(){

            @Override
            public void read(ByteBuffer dst, final SingleResultCallback<Integer> callback) {
                asynchronousByteChannel.read(dst, null, new CompletionHandler<Integer, Object>(){

                    @Override
                    public void completed(Integer result, Object attachment) {
                        callback.onResult((Object)result, null);
                    }

                    @Override
                    public void failed(Throwable exc, Object attachment) {
                        callback.onResult(null, exc);
                    }
                });
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    asynchronousByteChannel.close();
                    callback.onResult(null, null);
                }
                catch (Exception e) {
                    callback.onResult(null, (Throwable)e);
                }
            }
        };
    }

    public static AsyncInputStream channelToInputStream(final AsynchronousFileChannel asynchronousFileChannel) {
        Assertions.notNull((String)"asynchronousByteChannel", (Object)asynchronousFileChannel);
        return new AsyncInputStream(){
            private int position = 0;

            @Override
            public void read(ByteBuffer dst, final SingleResultCallback<Integer> callback) {
                asynchronousFileChannel.read(dst, this.position, null, new CompletionHandler<Integer, Object>(){

                    @Override
                    public void completed(Integer result, Object attachment) {
                        position += result;
                        callback.onResult((Object)result, null);
                    }

                    @Override
                    public void failed(Throwable exc, Object attachment) {
                        callback.onResult(null, exc);
                    }
                });
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    asynchronousFileChannel.close();
                    callback.onResult(null, null);
                }
                catch (Exception e) {
                    callback.onResult(null, (Throwable)e);
                }
            }
        };
    }

    public static AsyncOutputStream channelToOutputStream(final AsynchronousByteChannel asynchronousByteChannel) {
        Assertions.notNull((String)"asynchronousByteChannel", (Object)asynchronousByteChannel);
        return new AsyncOutputStream(){

            @Override
            public void write(ByteBuffer src, final SingleResultCallback<Integer> callback) {
                asynchronousByteChannel.write(src, null, new CompletionHandler<Integer, Object>(){

                    @Override
                    public void completed(Integer result, Object attachment) {
                        callback.onResult((Object)result, null);
                    }

                    @Override
                    public void failed(Throwable exc, Object attachment) {
                        callback.onResult(null, exc);
                    }
                });
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    asynchronousByteChannel.close();
                    callback.onResult(null, null);
                }
                catch (IOException e) {
                    callback.onResult(null, (Throwable)e);
                }
            }
        };
    }

    public static AsyncOutputStream channelToOutputStream(final AsynchronousFileChannel asynchronousFileChannel) {
        Assertions.notNull((String)"asynchronousByteChannel", (Object)asynchronousFileChannel);
        return new AsyncOutputStream(){
            private int position = 0;

            @Override
            public void write(ByteBuffer src, final SingleResultCallback<Integer> callback) {
                asynchronousFileChannel.write(src, this.position, null, new CompletionHandler<Integer, Object>(){

                    @Override
                    public void completed(Integer result, Object attachment) {
                        position += result;
                        callback.onResult((Object)result, null);
                    }

                    @Override
                    public void failed(Throwable exc, Object attachment) {
                        callback.onResult(null, exc);
                    }
                });
            }

            @Override
            public void close(SingleResultCallback<Void> callback) {
                try {
                    asynchronousFileChannel.close();
                    callback.onResult(null, null);
                }
                catch (IOException e) {
                    callback.onResult(null, (Throwable)e);
                }
            }
        };
    }

    private AsynchronousChannelHelper() {
    }
}

