#ifndef LIBRARIES_OPENPCI_H
#define LIBRARIES_OPENPCI_H

/*
**	$VER: openpci.h 2.1 (29.02.2008)
**	Includes Release 2.1
**
**	openpci.library interface structures and definitions.
**
*/

/*****************************************************************************/


#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

/* Conversion Little Endian(x86) -> Big Endian (68k) */
#ifndef OPENPCI_SWAP
#define OPENPCI_SWAP
// It is better to do not use such swapl/swapw() macro because there's race conditions in some cases
#define swapl(x) (((x&0x000000FF)<<24)+((x&0x0000FF00)<<8)+((x&0x00FF0000)>>8)+((x&0xFF000000)>>24))
#define swapw(x) ( ((x&0x00FF)<<8)+((x&0xFF00)>>8) )
// It is better to use following function for swapl/swapw it is commented for compatibility
/*
inline static unsigned long swapl(unsigned long x)
{
	return 
	(((x & 0xFF000000) >> 24) |
	((x & 0x00FF0000) >> 8)  |
	((x & 0x0000FF00) << 8)  |
	((x & 0x000000FF) << 24));
}

inline static unsigned short swapw(unsigned short x)
{
	return 
	(((x & 0xFF00) >> 8)  | 
	((x & 0x00FF) << 8));
}
*/
#endif


/* pci_bus() result flags */
#define MediatorA1200Bus	0x1
#define MediatorZ4Bus		0x2
#define PrometheusBus		0x4
#define GrexA1200Bus			0x8
#define GrexA4000Bus			0x10
#define PegasosBus			0x20
#define PowerPciBus			0x40

/* pci_allocdma_mem flags */
#define MEM_PCI				0x1
#define MEM_NONCACHEABLE	0x2

#define MIN_OPENPCI_VERSION 2 /* Version 2 or more */

/*****************************************************************************/


#if defined(__GNUC__)
# pragma pack(2)
#endif

 struct  pci_dev  {
          struct  pci_bus  *bus;            /* bus this device is on */
          struct  pci_dev  *next;           /* Next pci_dev */
          struct  pci_dev  *pred;			  /* Previous pci_dev */

          unsigned   char     devfn;           /* encoded device & function index */
          unsigned   short   vendor;
          unsigned   short   device;
          unsigned   int     devclass;           /* 3 bytes: (base,sub,prog-if) */
          unsigned   int     hdr_type;        /* PCI header type */
#if defined(__VBCC__)
          unsigned   short   master;
#else
          unsigned   int     master : 1;      /* set if device is master capable */
#endif
          /*
          * In theory, the irq level can be read from configuration
          * space and all would be fine.  However, old PCI chips don't
          * support these registers and return 0 instead.  For example,
          * the Vision864-P rev 0 chip can uses INTA, but returns 0 in
          * the interrupt line and pin registers.  pci_init()
          * initializes this field with the value at PCI_INTERRUPT_LINE
          * and it is the job of pcibios_fixup() to change it if
          * necessary.  The field must not be 0 unless the device
          * cannot generate interrupts at all.
          */
          unsigned   int     irq;             /* irq generated by this device */

          /* Base registers for this device, can be adjusted by
          * pcibios_fixup() as necessary.
          */
          unsigned   long    base_address[6];
          unsigned	long	  base_size[6];
          unsigned   long    rom_address;
          unsigned	long	  rom_size;
          
          void *reserved;
 };

 struct  pci_bus  {
          struct  pci_bus  *parent;         /* parent bus this bridge is on */
          struct  pci_bus  *children;       /* chain of P2P bridges on this bus */
          struct  pci_bus  *next;           /* chain of all PCI buses */

          struct  pci_dev  *self;           /* bridge device as seen by parent */
          struct  pci_dev  *devices;        /* devices behind this bridge */

          unsigned   char    number;          /* bus number */
          unsigned   char    primary;         /* number of primary bridge */
          unsigned   char    secondary;       /* number of secondary bridge */
          unsigned   char    subordinate;     /* max number of subordinate buses */
 };

#if defined(__GNUC__)
# pragma pack()
#endif

 /*
  * Under PCI, each device has 256 bytes of configuration address space,
  * of which the first 64 bytes are standardized as follows:
  */
 #define  PCI_VENDOR_ID           0x00     /* 16 bits */
 #define  PCI_DEVICE_ID           0x02     /* 16 bits */
 #define  PCI_COMMAND             0x04     /* 16 bits */
 #define   PCI_COMMAND_IO         0x1      /* Enable response in I/O space */
 #define   PCI_COMMAND_MEMORY     0x2      /* Enable response in Memory space */
 #define   PCI_COMMAND_MASTER     0x4      /* Enable bus mastering */
 #define   PCI_COMMAND_SPECIAL    0x8      /* Enable response to special cycles */
 #define   PCI_COMMAND_INVALIDATE 0x10     /* Use memory write and invalidate */
 #define   PCI_COMMAND_VGA_PALETTE 0x20    /* Enable palette snooping */
 #define   PCI_COMMAND_PARITY     0x40     /* Enable parity checking */
 #define   PCI_COMMAND_WAIT       0x80     /* Enable address/data stepping */
 #define   PCI_COMMAND_SERR       0x100    /* Enable SERR */
 #define   PCI_COMMAND_FAST_BACK  0x200    /* Enable back-to-back writes */

 #define  PCI_STATUS              0x06     /* 16 bits */
 /* Bit 3..0:    reserved */
 #define   PCI_NEW_CAPABILITIES	  0x10	   /* Support New Capabilities Linked List (PCI 2.2) */
 #define   PCI_STATUS_66MHZ       0x20     /* Support 66 Mhz PCI 2.1 bus */
 #define   PCI_STATUS_UDF         0x40     /* Support User Definable Features */
 #define   PCI_STATUS_FAST_BACK   0x80     /* Accept fast-back to back */
 #define   PCI_STATUS_PARITY      0x100    /* Detected parity error */
 #define   PCI_STATUS_DEVSEL_MASK 0x600    /* DEVSEL timing */
 #define   PCI_STATUS_DEVSEL_FAST 0x000   
 #define   PCI_STATUS_DEVSEL_MEDIUM 0x200
 #define   PCI_STATUS_DEVSEL_SLOW 0x400
 /* PCI Errors detected */
 #define   PCI_STATUS_SIG_TARGET_ABORT 0x800  /* Set on target abort */
 #define   PCI_STATUS_REC_TARGET_ABORT 0x1000  /* Master ack of " */
 #define   PCI_STATUS_REC_MASTER_ABORT 0x2000  /* Set on master abort */
 #define   PCI_STATUS_SIG_SYSTEM_ERROR 0x4000  /* Set when we drive SERR */
 #define   PCI_STATUS_DETECTED_PARITY 0x8000  /* Set on parity error */
 #define   PCI_STATUS_ERRBITS     (PCI_STATUS_SIG_TARGET_ABORT | PCI_STATUS_REC_TARGET_ABORT | PCI_STATUS_REC_MASTER_ABORT | PCI_STATUS_SIG_SYSTEM_ERROR | PCI_STATUS_DETECTED_PARITY)

 #define  PCI_CLASS_REVISION      0x08     /* High 24 bits are class, low 8
                                            revision */
 #define  PCI_REVISION_ID         0x08     /* Revision ID */
 #define  PCI_CLASS_PROG          0x09     /* Reg. Level Programming Interface */
 #define  PCI_CLASS_DEVICE        0x0a     /* Device class */

 #define  PCI_CACHE_LINE_SIZE     0x0c     /* 8 bits */
 #define  PCI_LATENCY_TIMER       0x0d     /* 8 bits */
 #define  PCI_HEADER_TYPE         0x0e     /* 8 bits */
 #define   PCI_HEADER_TYPE_NORMAL 0			/* bit 0=0 */
 #define   PCI_HEADER_TYPE_BRIDGE 1			/* bit 0=1 */
 #define   PCI_HEADER_TYPE_CARDBUS 2		/* bit 1=1 */
 /* PCI_HEADER_TYPE bit 2 to 6 are reserved bit7=1 multi function device */

 #define  PCI_BIST                0x0f     /* 8 bits */
 #define  PCI_BIST_CODE_MASK      0x0f     /* Return result */
 #define  PCI_BIST_START          0x40     /* 1 to start BIST, 2 secs or less */
 #define  PCI_BIST_CAPABLE        0x80     /* 1 if BIST capable */

 /*
  * Base addresses specify locations in memory or I/O space.
  * Decoded size can be determined by writing a value of 
  * 0xffffffff to the register, and reading it back.  Only 
  * 1 bits are decoded.
  */
 #define  PCI_BASE_ADDRESS_0      0x10     /* 32 bits */
 #define  PCI_BASE_ADDRESS_1      0x14     /* 32 bits [htype 0,1 only] */
 #define  PCI_BASE_ADDRESS_2      0x18     /* 32 bits [htype 0 only] */
 #define  PCI_BASE_ADDRESS_3      0x1c     /* 32 bits */
 #define  PCI_BASE_ADDRESS_4      0x20     /* 32 bits */
 #define  PCI_BASE_ADDRESS_5      0x24     /* 32 bits */
 #define   PCI_BASE_ADDRESS_SPACE 0x01     /* 0 = memory, 1 = I/O */
 #define   PCI_BASE_ADDRESS_SPACE_IO 0x01
 #define   PCI_BASE_ADDRESS_SPACE_MEMORY 0x00
 #define   PCI_BASE_ADDRESS_MEM_TYPE_MASK 0x06
 #define   PCI_BASE_ADDRESS_MEM_TYPE_32   0x00     /* 32 bit address */
 #define   PCI_BASE_ADDRESS_MEM_TYPE_1M   0x02     /* Below 1M */
 #define   PCI_BASE_ADDRESS_MEM_TYPE_64   0x04     /* 64 bit address */
 #define   PCI_BASE_ADDRESS_MEM_PREFETCH  0x08     /* prefetchable? */
 #define   PCI_BASE_ADDRESS_MEM_MASK      (~0x0fUL)
 #define   PCI_BASE_ADDRESS_IO_MASK       (~0x03UL)
 /* bit 1 is reserved if address_space = 1 */

 /* Header type 0 (normal devices) */
 #define  PCI_CARDBUS_CIS         0x28
 #define  PCI_SUBSYSTEM_VENDOR_ID 0x2c
 #define  PCI_SUBSYSTEM_ID        0x2e  
 #define  PCI_ROM_ADDRESS         0x30     /* Bits 31..11 are address, 10..1 reserved */
 #define   PCI_ROM_ADDRESS_ENABLE 0x01
 #define  PCI_ROM_ADDRESS_MASK    (~0x7ffUL)

 #define  PCI_CAPABILITIES_PTR    0x34	   /* 8 bits (PCI 2.2) */
 /* 0x38-0x3b are reserved */
 #define  PCI_INTERRUPT_LINE      0x3c     /* 8 bits */
 #define  PCI_INTERRUPT_PIN       0x3d     /* 8 bits */
 #define  PCI_MIN_GNT             0x3e     /* 8 bits */
 #define  PCI_MAX_LAT             0x3f     /* 8 bits */

 /* Header type 1 (PCI-to-PCI bridges) */
 #define  PCI_PRIMARY_BUS         0x18     /* Primary bus number */
 #define  PCI_SECONDARY_BUS       0x19     /* Secondary bus number */
 #define  PCI_SUBORDINATE_BUS     0x1a     /* Highest bus number behind the bridge */
 #define  PCI_SEC_LATENCY_TIMER   0x1b     /* Latency timer for secondary interface */
 #define  PCI_IO_BASE             0x1c     /* I/O range behind the bridge */
 #define  PCI_IO_LIMIT            0x1d
 #define   PCI_IO_RANGE_TYPE_MASK 0x0f     /* I/O bridging type */
 #define   PCI_IO_RANGE_TYPE_16   0x00
 #define   PCI_IO_RANGE_TYPE_32   0x01
 #define   PCI_IO_RANGE_MASK      ~0x0f
 #define  PCI_SEC_STATUS          0x1e     /* Secondary status register, only bit 14 used */
 #define  PCI_MEMORY_BASE         0x20     /* Memory range behind */
 #define  PCI_MEMORY_LIMIT        0x22
 #define   PCI_MEMORY_RANGE_TYPE_MASK 0x0f
 #define   PCI_MEMORY_RANGE_MASK  ~0x0f
 #define  PCI_PREF_MEMORY_BASE    0x24     /* Prefetchable memory range behind */
 #define  PCI_PREF_MEMORY_LIMIT   0x26
 #define   PCI_PREF_RANGE_TYPE_MASK 0x0f
 #define   PCI_PREF_RANGE_TYPE_32 0x00
 #define   PCI_PREF_RANGE_TYPE_64 0x01
 #define   PCI_PREF_RANGE_MASK    ~0x0f
 #define  PCI_PREF_BASE_UPPER32   0x28     /* Upper half of prefetchable memory range */
 #define  PCI_PREF_LIMIT_UPPER32  0x2c
 #define  PCI_IO_BASE_UPPER16     0x30     /* Upper half of I/O addresses */
 #define  PCI_IO_LIMIT_UPPER16    0x32
 /* 0x34-0x3b is reserved */
 #define  PCI_ROM_ADDRESS1        0x38     /* Same as PCI_ROM_ADDRESS, but for htype 1 */
 /* 0x3c-0x3d are same as for htype 0 */
 #define  PCI_BRIDGE_CONTROL      0x3e
 #define   PCI_BRIDGE_CTL_PARITY  0x01     /* Enable parity detection on secondary interface */
 #define   PCI_BRIDGE_CTL_SERR    0x02     /* The same for SERR forwarding */
 #define   PCI_BRIDGE_CTL_NO_ISA  0x04     /* Disable bridging of ISA ports */
 #define   PCI_BRIDGE_CTL_VGA     0x08     /* Forward VGA addresses */
 #define   PCI_BRIDGE_CTL_MASTER_ABORT 0x20   /* Report master aborts */
 #define   PCI_BRIDGE_CTL_BUS_RESET 0x40   /* Secondary bus reset */
 #define   PCI_BRIDGE_CTL_FAST_BACK 0x80   /* Fast Back2Back enabled on secondary interface */

 /* Header type 2 (CardBus bridges) */
 /* 0x14-0x15 reserved */
 #define  PCI_CB_SEC_STATUS       0x16     /* Secondary status */
 #define  PCI_CB_PRIMARY_BUS      0x18     /* PCI bus number */
 #define  PCI_CB_CARD_BUS         0x19     /* CardBus bus number */
 #define  PCI_CB_SUBORDINATE_BUS  0x1a     /* Subordinate bus number */
 #define  PCI_CB_LATENCY_TIMER    0x1b     /* CardBus latency timer */
 #define  PCI_CB_MEMORY_BASE_0    0x1c
 #define  PCI_CB_MEMORY_LIMIT_0   0x20
 #define  PCI_CB_MEMORY_BASE_1    0x24
 #define  PCI_CB_MEMORY_LIMIT_1   0x28
 #define  PCI_CB_IO_BASE_0        0x2c
 #define  PCI_CB_IO_BASE_0_HI     0x2e
 #define  PCI_CB_IO_LIMIT_0       0x30
 #define  PCI_CB_IO_LIMIT_0_HI    0x32
 #define  PCI_CB_IO_BASE_1        0x34
 #define  PCI_CB_IO_BASE_1_HI     0x36
 #define  PCI_CB_IO_LIMIT_1       0x38
 #define  PCI_CB_IO_LIMIT_1_HI    0x3a
 #define   PCI_CB_IO_RANGE_MASK   ~0x03
 /* 0x3c-0x3d are same as for htype 0 */
 #define  PCI_CB_BRIDGE_CONTROL   0x3e
 #define   PCI_CB_BRIDGE_CTL_PARITY       0x01     /* Similar to standard bridge control register */
 #define   PCI_CB_BRIDGE_CTL_SERR         0x02
 #define   PCI_CB_BRIDGE_CTL_ISA          0x04
 #define   PCI_CB_BRIDGE_CTL_VGA          0x08
 #define   PCI_CB_BRIDGE_CTL_MASTER_ABORT 0x20
 #define   PCI_CB_BRIDGE_CTL_CB_RESET     0x40     /* CardBus reset */
 #define   PCI_CB_BRIDGE_CTL_16BIT_INT    0x80     /* Enable interrupt for 16-bit cards */
 #define   PCI_CB_BRIDGE_CTL_PREFETCH_MEM0 0x100   /* Prefetch enable for both memory regions */
 #define   PCI_CB_BRIDGE_CTL_PREFETCH_MEM1 0x200
 #define   PCI_CB_BRIDGE_CTL_POST_WRITES  0x400
 #define  PCI_CB_SUBSYSTEM_VENDOR_ID 0x40
 #define  PCI_CB_SUBSYSTEM_ID     0x42
 #define  PCI_CB_LEGACY_MODE_BASE 0x44     /* 16-bit PC Card legacy mode base address (ExCa) */
 /* 0x48-0x7f reserved */

 /* Device classes and subclasses */

 #define  PCI_CLASS_NOT_DEFINED           0x0000
 #define  PCI_CLASS_NOT_DEFINED_VGA       0x0001

 #define  PCI_BASE_CLASS_STORAGE          0x01
 #define  PCI_CLASS_STORAGE_SCSI          0x0100
 #define  PCI_CLASS_STORAGE_IDE           0x0101
 #define  PCI_CLASS_STORAGE_FLOPPY        0x0102
 #define  PCI_CLASS_STORAGE_IPI           0x0103
 #define  PCI_CLASS_STORAGE_RAID          0x0104
 #define  PCI_CLASS_STORAGE_OTHER         0x0180

 #define  PCI_BASE_CLASS_NETWORK          0x02
 #define  PCI_CLASS_NETWORK_ETHERNET      0x0200
 #define  PCI_CLASS_NETWORK_TOKEN_RING    0x0201
 #define  PCI_CLASS_NETWORK_FDDI          0x0202
 #define  PCI_CLASS_NETWORK_ATM           0x0203
 #define  PCI_CLASS_NETWORK_OTHER         0x0280

 #define  PCI_BASE_CLASS_DISPLAY          0x03
 #define  PCI_CLASS_DISPLAY_VGA           0x0300
 #define  PCI_CLASS_DISPLAY_XGA           0x0301
 #define  PCI_CLASS_DISPLAY_OTHER         0x0380

 #define  PCI_BASE_CLASS_MULTIMEDIA       0x04
 #define  PCI_CLASS_MULTIMEDIA_VIDEO      0x0400
 #define  PCI_CLASS_MULTIMEDIA_AUDIO      0x0401
 #define  PCI_CLASS_MULTIMEDIA_OTHER      0x0480

 #define  PCI_BASE_CLASS_MEMORY           0x05
 #define   PCI_CLASS_MEMORY_RAM           0x0500
 #define   PCI_CLASS_MEMORY_FLASH         0x0501
 #define   PCI_CLASS_MEMORY_OTHER         0x0580

 #define  PCI_BASE_CLASS_BRIDGE           0x06
 #define   PCI_CLASS_BRIDGE_HOST          0x0600
 #define   PCI_CLASS_BRIDGE_ISA           0x0601
 #define   PCI_CLASS_BRIDGE_EISA          0x0602
 #define   PCI_CLASS_BRIDGE_MC            0x0603
 #define   PCI_CLASS_BRIDGE_PCI           0x0604
 #define   PCI_CLASS_BRIDGE_PCMCIA        0x0605
 #define   PCI_CLASS_BRIDGE_NUBUS         0x0606
 #define   PCI_CLASS_BRIDGE_CARDBUS       0x0607
 #define   PCI_CLASS_BRIDGE_OTHER         0x0680

 #define  PCI_BASE_CLASS_COMMUNICATION    0x07
 #define  PCI_CLASS_COMMUNICATION_SERIAL  0x0700
 #define  PCI_CLASS_COMMUNICATION_PARALLEL 0x0701
 #define  PCI_CLASS_COMMUNICATION_OTHER   0x0780

 #define  PCI_BASE_CLASS_SYSTEM           0x08
 #define  PCI_CLASS_SYSTEM_PIC            0x0800
 #define  PCI_CLASS_SYSTEM_DMA            0x0801
 #define  PCI_CLASS_SYSTEM_TIMER          0x0802
 #define  PCI_CLASS_SYSTEM_RTC            0x0803
 #define  PCI_CLASS_SYSTEM_OTHER          0x0880

 #define  PCI_BASE_CLASS_INPUT            0x09
 #define  PCI_CLASS_INPUT_KEYBOARD        0x0900
 #define  PCI_CLASS_INPUT_PEN             0x0901
 #define  PCI_CLASS_INPUT_MOUSE           0x0902
 #define  PCI_CLASS_INPUT_OTHER           0x0980

 #define  PCI_BASE_CLASS_DOCKING          0x0a
 #define  PCI_CLASS_DOCKING_GENERIC       0x0a00
 #define  PCI_CLASS_DOCKING_OTHER         0x0a01

 #define  PCI_BASE_CLASS_PROCESSOR        0x0b
 #define  PCI_CLASS_PROCESSOR_386         0x0b00
 #define  PCI_CLASS_PROCESSOR_486         0x0b01
 #define  PCI_CLASS_PROCESSOR_PENTIUM     0x0b02
 #define  PCI_CLASS_PROCESSOR_ALPHA       0x0b10
 #define  PCI_CLASS_PROCESSOR_POWERPC     0x0b20
 #define  PCI_CLASS_PROCESSOR_CO          0x0b40

 #define  PCI_BASE_CLASS_SERIAL           0x0c
 #define  PCI_CLASS_SERIAL_FIREWIRE       0x0c00
 #define  PCI_CLASS_SERIAL_ACCESS         0x0c01
 #define  PCI_CLASS_SERIAL_SSA            0x0c02
 #define  PCI_CLASS_SERIAL_USB            0x0c03
 #define  PCI_CLASS_SERIAL_FIBER          0x0c04

 #define  PCI_CLASS_OTHERS                0xff


 /*
  * The PCI interface treats multi-function devices as independent
  * devices.  The slot/function address of each device is encoded
  * in a single byte as follows:
  *
  *      7:3 = slot
  *      2:0 = function
  *      
  *      see pci_find_slot()
  */
 #define   PCI_DEVFN(slot,func)    ((((slot) & 0x1f) << 3) | ((func) & 0x07))
 #define   PCI_SLOT(devfn)         (((devfn) >> 3) & 0x1f)
 #define   PCI_FUNC(devfn)         ((devfn) & 0x07)

#endif /* LIBRARIES_OPENPCI_H */
