/* $VER: Start-Amplifier.rexx 1.1 (28.11.2000) */

OPTIONS RESULTS
PARSE ARG files

/* Enter here where Amplifier can be found */
/* Hier eintragen, wo Amplifier gefunden werden kann */
amplifier_path="SYS:Utilities/Amplifier"
amplifier_app="Amplifier"
amplifier_port="AMPLIFIER.1"

olddir=PRAGMA("DIRECTORY", amplifier_path)
oldstack=PRAGMA("STACK", 10240)

/* Start Amplifier */
IF ~SHOW("PORT", amplifier_port) THEN DO
    ADDRESS COMMAND "RUN >NIL: Amplifier"
    ADDRESS COMMAND "WaitForPort "amplifier_port
    IF ~SHOW("PORT", amplifier_port) THEN DO
        ADDRESS COMMAND "WaitForPort "amplifier_port
        IF ~SHOW("PORT", amplifier_port) THEN DO
            ADDRESS COMMAND "WaitForPort "amplifier_port
            IF ~SHOW("PORT", amplifier_port) THEN DO
                SAY "Couldn't start Amplifier!"
                EXIT
            END
        END
    END
END

/* Add files to playlist */
firstfile=""
DO WHILE files~=="" 
    files=STRIP(files)
    IF files~=="" THEN DO
        IF left(files,1)='"' THEN DO
            PARSE VAR files '"'file'"' files
        END
        ELSE DO
            PARSE VAR files file" "files
        END

        /* Workbench unfortunately doesn't give absolute */
        /* path names for the file arguments and Amplifier */
        /* actual path is the Amplifier program dir */
        /* So we add path names if file has relative path */
        IF POS(":", file)=0 THEN DO
            IF RIGHT(olddir,1)==":" THEN DO
                file=olddir || file
            END 
            ELSE DO
                file=olddir"/"file
            END                
        END
        /* Add file to playlist */
        IF EXISTS(file) THEN DO
            ADDRESS VALUE amplifier_port 
            ADD '"'file'"'
            ADDRESS
            IF firstfile=="" THEN DO
                firstfile=file
            END
        END
    END
END 

/* Start playing the first added title */
ADDRESS VALUE amplifier_port
'STOP'
'OPEN "'firstfile'"'
'PLAY'
ADDRESS

olddir=PRAGMA("DIRECTORY",olddir)
oldstack=PRAGMA("STACK",oldstack)
