#ifndef LIBRARIES_MIXER_H
#define LIBRARIES_MIXER_H
/*
**    $VER: mixer.h 2.2 (07.02.03)
**    Definitions for the mixer.library.
**
**    (C) Copyright 2001 Elbox Computer.
**        All Rights Reserved
*/

#ifndef EXEC_TYPES_H
#include "exec/types.h"
#endif    /* EXEC_TYPES_H */

/* AudioTypes */
#define MASTER          0x01
#define HEADPHONE       0x02
#define MASTER_MONO     0x03
#define PHONE           0x04

#define MIC             0x05
#define LINE_IN         0x06
#define CD_AUDIO        0x07
#define VIDEO           0x08

#define AUX             0x09
#define PCM             0x0A
#define MIDI            0x0B
#define SPDIF-IN        0x0C

#define BASS            0x0D
#define TREBLE          0x0E
#define RECORD_SRC      0x0F
#define RECORD_VOL      0x10

#define 3D_CONTROL      0x11



#define    MinBass      0x00 
#define    MaxBass      0x7F
#define    MinTreble    0x00
#define    MaxTreble    0x7F


/* Volume for right channel or mono in bits 0-6 */
/* Volume for left channel in bits 8-14 */


#define MinVolume        0x00
#define MaxVolume        0x7F

/* special flags for SetAudioType - Variable argument */
#define MIXERB_MUTE               16    /* set only with volume audio types */
#define MIXERB_MIC20dB            17    /* set only with audio type MIC */
#define MIXERB_DIGITALOUT_ONLY    17    /* set only with audio type MASTER */

#define MIXERF_MUTE               (1<<16)
#define MIXERF_MIC20dB            (1<<17)
#define MIXERF_DIGITALOUT_ONLY    (1<<17)
#define MIXERF_DIGITALOUT_SB41    (1<<18)

#endif    /* LIBRARIES_MIXER_H */
