#ifndef LIBRARIES_TV_H
#define LIBRARIES_TV_H
/*
**    $VER: tv.h 2.0 (13.07.04)
**    Definitions for the tv.library ver. 4.0.
**
**    (C) Copyright 2001-2004 Elbox Computer.
**        All Rights Reserved
*/

#ifndef EXEC_TYPES_H
#include "exec/types.h"
#endif    /* EXEC_TYPES_H */

/* Signal formats */
#define NTSC_M           0x01
#define NTSC_MJ          0x02
#define PAL_BDGHI        0x03
#define PAL_M            0x04
#define PAL_N            0x05
#define SECAM            0x06
#define PAL_NC           0x07

/* Audio modes */
#define TUNER            0x00
#define RADIO            0x01
#define EXTERNAL         0x02
#define INTERNAL         0x03
#define MUTE             0x04

/* Flags for SetAudioMode function (from tv.lib ver.4.0)*/
#define TVF_AM_NEWSTYLE     (1<<31)
#define TVB_AM_NEWSTYLE     31
#define TVF_STEREO          (1<<15)
#define TVB_STEREO          15
#define TVF_MUTE            (1<<14)
#define TVB_MUTE            14
#define TVF_TV              0
#define TVF_RADIO           1
#define TVF_EXTERNAL        2



/* Flags for SetTunerFreq function */
#define TVB_RADIO            0
#define TVB_FREQ_STEP1       1    
#define TVB_FREQ_STEP2       2

/* TVB_FREQ_STEP1 | TVB_FREQ_STEP2 | tuning step [kHz] */
/* ----------------------------------------------------*/
/*       0        |        x       |        62.50      */
/*       1        |        0       |        31.25      */
/*       1        |        1       |        50.00      */

#define TVF_RADIO            (1<<0)
#define TVF_FREQ_STEP1       (1<<1)
#define TVF_FREQ_STEP2       (1<<2)

/* Flag for OpenTVWindow function */
#define TVB_BACKDROP         31
#define TVF_BACKDROP         (1<<31)

/* Flag for SetVideoInput function */
#define TVB_SVHS             16
#define TVF_SVHS             (1<<16)

struct i2c_Message 
{
    UWORD i2c_Addr;   /* slave device address     */
    UBYTE i2c_Flags;        
    UBYTE i2c_Length; /* number of bytes to be transfered */
    char *i2c_Buffer; /* pointer to read or write buffer */
};

/* i2c_Flags  */
#define I2CB_READ            0        /* set this flag for read transaction */
#define I2CF_READ            (1<<0)
#define I2CB_NORESTART       1        /* set this flag if you don't need repeated start condition */
#define I2CF_NORESTART       (1<<1)
#endif   /* LIBRARIES_TV_H */
